/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class RepeatingList<E>
extends AbstractList<E> {
    private final List<RepeatedEl<E>> list = Lists.newArrayList();
    private int size = 0;

    public static <E> RepeatingList<E> create() {
        return new RepeatingList<E>();
    }

    @Override
    public boolean add(E e) {
        return this.addNTimes(1, e);
    }

    public boolean addNTimes(int times, E e) {
        Preconditions.checkArgument(times >= 0);
        if (times > 0) {
            this.list.add(new RepeatedEl<E>(e, times));
            this.size += times;
        }
        return true;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new RepeatingIterator<E>(this.list.iterator());
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        int sum = 0;
        for (RepeatedEl<E> el : this.list) {
            if ((sum += el.n) <= index) continue;
            return el.e;
        }
        return this.list.get((int)(this.list.size() - 1)).e;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private static class RepeatedEl<E> {
        public final E e;
        public final int n;

        private RepeatedEl(E e, int n) {
            this.e = e;
            this.n = n;
        }
    }

    private static class RepeatingIterator<E>
    implements Iterator<E> {
        private final Iterator<RepeatedEl<E>> elIterator;
        private E curr;
        private int currReps;
        private boolean hasNext;

        private RepeatingIterator(Iterator<RepeatedEl<E>> iterator) {
            this.elIterator = iterator;
            this.resolveNextRepeatedEl();
            --this.currReps;
        }

        private void resolveNextRepeatedEl() {
            this.hasNext = this.elIterator.hasNext();
            if (this.hasNext) {
                RepeatedEl<E> el = this.elIterator.next();
                this.curr = el.e;
                this.currReps = el.n;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            E res = this.curr;
            if (this.currReps <= 0) {
                this.resolveNextRepeatedEl();
            }
            --this.currReps;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

